﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using PI.FM.N000.Base.WinForms.Ribbon;
using Gemini.Core.WinForms.Controls.Type;
using Gemini.Core.WinForms.Controls.Interface;
using Gemini.Core.WinForms.Base;


namespace PI.ZB.N1200.ELearning.WinForms.ExerciseAvatar
{
    public partial class UCExerciseAvatarDetails : PI.FM.N000.Base.WinForms.Controls.UCBODetails<BL.BO.ExerciseAvatar, BL.BO.ExerciseAvatar.Search>
    {
        private const int _IndexTabExerciseAvatar = 0;
        protected     int _IndexTabSystemInformation        = 1;


        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private UCTabExerciseAvatarDetails _tabExerciseAvatarDetails = null;

        public UCTabExerciseAvatarDetails TabExerciseAvatarDetails
        {
            get
            {
                if (_tabExerciseAvatarDetails == null)
                {
                    _tabExerciseAvatarDetails = new UCTabExerciseAvatarDetails();
                }
                return _tabExerciseAvatarDetails;
            }
        }

        protected PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        protected int IndexTabSystemInformation
        {
            set
            {
                _IndexTabSystemInformation = value;
            }
            get
            {
                return _IndexTabSystemInformation;
            }
        }

        public UCExerciseAvatarDetails()
        {
            InitializeComponent();

            AddStandardControlTabs();
            MinimumHorizontalSize = 400;
            MinimumVerticalSize = 190;
        }

        protected void AddStandardControlTabs()
        {
            this.AddControlAtTab(_IndexTabExerciseAvatar, TabExerciseAvatarDetails, "Ustawienia");
            this.AddControlAtTab(_IndexTabSystemInformation     , TabSystemInformation      , "Informacje systemowe");
        }

        public override void Initialize(Gemini.Core.WinForms.Interface.IPlugIn ParentPlugIn, Gemini.Core.WinForms.Interface.IEnvironment ParentEnvironment)
        {
            base.Initialize(ParentPlugIn, ParentEnvironment);

            TabExerciseAvatarDetails.Initialize(this, Environment, ParentPlugIn);
            TabSystemInformation.Initialize(this, Environment, ParentPlugIn);
        }

        protected override Gemini.Core.BL.Base.MethodResult DoSave()
        {
            Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

            TabExerciseAvatarDetails.Save();
            _methodResult = BLZSBELearning.Avatar.Save(DataManager.Current);

            return _methodResult;
        }

        protected override bool DoRestore(long? ID)
        {
            bool _result = false;
            BL.BO.ExerciseAvatar _ExerciseAvatar = BLZSBELearning.Avatar.Restore(ID);
            if (_ExerciseAvatar != null)
            {
                _result = true;
                DataManager.LoadData(null, null, _ExerciseAvatar);
                TabExerciseAvatarDetails.Restore();

                this.CreateToolbarActions();
            }

            return _result;
        }

        protected override Gemini.Core.BL.Base.MethodResult DoRemove()
        {
            return BLZSBELearning.Avatar.Remove(DataManager.Current);
        }
    }
}
